﻿using System;
using System.Web.UI.WebControls;
using System.ComponentModel;

public partial class controls_FromToDate : System.Web.UI.UserControl
{
    public string DateValue
    {
        get
        {
            return TextBoxDate.Text;
        }
        set
        {
            TextBoxDate.Text = value;
        }
    }
    [Browsable(true)]
    [Description("CustomValidatorTextBoxDate ValidationGroup")]
    [DefaultValue("Save")]
    public string CustomValidatorValidationGroup
    {
        set
        {
            if (!string.IsNullOrEmpty(value))
            {
                this.CustomValidatorTextBoxDate.ValidationGroup = value;
            }
            else if (!string.IsNullOrEmpty(RangeValidatorTxtDate.ValidationGroup))
            {
                this.CustomValidatorTextBoxDate.ValidationGroup =
                    RangeValidatorTxtDate.ValidationGroup;
            }
        }
        get
        {
            return this.RangeValidatorTxtDate.ValidationGroup;
        }
    }
    [Description("Enable CustomValidatorTextBoxDate")]
    [DefaultValue(false)]
    public bool EnableToDateCompare
    {
        set
        {
            this.CustomValidatorTextBoxDate.Enabled = value;
        }
        get
        {
            return this.CustomValidatorTextBoxDate.Enabled;
        }
    }
    private string _toDateCompareErrorMessage;
    [Browsable(true)]
    [Description("RangeValidatorTxtDate ToDateCompare ErrorMessage")]
    [DefaultValue("")]
    public string ToDateCompareErrorMessage
    {
        get
        {
            return _toDateCompareErrorMessage;
        }
        set
        {
            _toDateCompareErrorMessage = value;
            CustomValidatorTextBoxDate.ErrorMessage = _toDateCompareErrorMessage;
        }
    }
    private string _toDateCompareDate;
    [Browsable(true)]
    [Description("ToDateCompare Date")]
    [DefaultValue("01/01/3000")]
    public string ToDateCompareDate
    {
        get
        {
            return _toDateCompareDate;
        }
        set
        {
            _toDateCompareDate = value;
        }
    }
    [Browsable(true)]
    [Description("RangeValidatorTxtDate ToDateCompare")]
    [DefaultValue(false)]
    public bool ToDateCompare
    {
        get
        {
            return _toDate;
        }
        set
        {
            _toDate = value;
            RangeValidatorTxtDate.MaximumValue = DateTime.Now.ToShortDateString();
        }
    }
    [Browsable(true)]
    [Description("RangeValidatorTxtDate Date Time From")]
    [DefaultValue("01/01/1900")]
    public string DateTimeFrom 
    {
        get
        {
            return RangeValidatorTxtDate.MinimumValue;
        }
        set
        {
            RangeValidatorTxtDate.MinimumValue = value;
        }
    }
    private bool _toDate = false;
    [Browsable(true)]
    [Description("RangeValidatorTxtDate ToDate")]
    [DefaultValue(false)]
    public bool ToDate
    {
        get
        {
            return _toDate;
        }
        set
        {
            _toDate = value;
            RangeValidatorTxtDate.MaximumValue = DateTime.Now.ToShortDateString();
        }
    }
    [Browsable(true)]
    [Description("RangeValidatorTxtDate ErrorMessage")]
    [DefaultValue("Invalid Date")]
    public string ErrorMessage
    {
        set
        {
            this.RangeValidatorTxtDate.ErrorMessage = value;
        }
        get
        {
            return this.RangeValidatorTxtDate.ErrorMessage;
        }
    }
    [Browsable(true)]
    [Description("RangeValidatorTxtDate ValidationGroup")]
    [DefaultValue("Save")]
    public string ValidationGroup
    {
        set
        {
            if( !string.IsNullOrEmpty(value))
            {
                this.RangeValidatorTxtDate.ValidationGroup = value;
            }
            else if (!string.IsNullOrEmpty(RequiredFieldValidatorTxtDate.ValidationGroup))
            {
                this.RangeValidatorTxtDate.ValidationGroup = 
                    RequiredFieldValidatorTxtDate.ValidationGroup;
            }
        }
        get
        {
            return this.RangeValidatorTxtDate.ValidationGroup;
        }
    }
    [Browsable(true)]
    [Description("RangeValidatorTxtDate StartTabIndex")]
    [DefaultValue("Save")]
    public short StartTabIndex
    {
        set
        {
            TextBoxDate.TabIndex = value;
            RangeValidatorTxtDate.TabIndex = (short)(value + 1);
            RequiredFieldValidatorTxtDate.TabIndex = (short)(value + 2);
        }
        get
        {
            return TextBoxDate.TabIndex;
        }
    }
    [Browsable(true)]
    [Description("Text Box Date")]
    public TextBox Date
    {
        set
        {
            TextBoxDate = value;
        }
        get
        {
            return TextBoxDate;
        }
    }
    [Browsable(true)]
    [Description("Enable RequiredFieldValidatorTxtDate")]
    [DefaultValue(false)]
    public bool Required
    {
        set
        {
            this.RequiredFieldValidatorTxtDate.Enabled = value;
        }
        get
        {
            return this.RequiredFieldValidatorTxtDate.Enabled;
        }
    }
    [Browsable(true)]
    [Description("RequiredFieldValidatorTxtDate ValidationGroup")]
    [DefaultValue("")]
    public string RequiredValidatorValidationGroup
    {
        set
        {
            if (!string.IsNullOrEmpty(value))
            {
                this.RequiredFieldValidatorTxtDate.ValidationGroup = value;

                if (string.IsNullOrEmpty(RangeValidatorTxtDate.ValidationGroup))
                {
                    this.RangeValidatorTxtDate.ValidationGroup= 
                        this.RequiredFieldValidatorTxtDate.ValidationGroup ;
                }
            }
            else if (!string.IsNullOrEmpty(RangeValidatorTxtDate.ValidationGroup))
            {
                this.RequiredFieldValidatorTxtDate.ValidationGroup = 
                    this.RangeValidatorTxtDate.ValidationGroup;
            }
        }
        get
        {
            return this.RequiredFieldValidatorTxtDate.ValidationGroup;
        }
    }
    [Browsable(true)]
    [Description("RequiredFieldValidatorTxtDate Error Message")]
    [DefaultValue("Date is required")]
    public string RequiredFieldValidatorErrorMessage
    {
        set
        {
            this.RequiredFieldValidatorTxtDate.ErrorMessage = value;
        }
        get
        {
            return this.RequiredFieldValidatorTxtDate.ErrorMessage;
        }
    }
    public DateTime DateTimeTo
    {
        get
        {
            return DateTime.Now;
        }
        //set
        //{
        //    this.PopCalendarTo.DateValue = value;
        //}
    }

    //[Browsable(true)]
    //[Description("Enable the 'From' date textbox")]
    //[DefaultValue(false)]
    //public bool EnableDateFromTextBox { set { this.TxtDate.Enabled = value; } get { return this.TxtDate.Enabled; }}

    //[Browsable(true)]
    //[Description("Enable the 'To' date textbox")]
    //[DefaultValue(false)]
    //public bool EnableDateToTextBox { set { this.txtToDate.Enabled = value; } get { return this.txtToDate.Enabled; } }

    protected void Page_Load(object sender, EventArgs e)
    {
    }


    void Page_PreRender(object sender, EventArgs e)
    {

        RangeValidatorTxtDate.MaximumValue = DateTime.Today.AddYears(100).ToShortDateString();
    }
    
    protected void CustomValidatorTextBoxDate_ServerValidate(object source, ServerValidateEventArgs args)
    {
        if (DateTime.Parse(DateValue) < DateTime.Parse(ToDateCompareDate))
        {
            args.IsValid = false;
        }
    }
}
